<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class CriaEstruturaLogradourosCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'instalacao:cria-estrutura-logradouros';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Cria a estrutura e insere dados utilizados para a busca de logradouros';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $diretorio = database_path('estrutura-logradouro');
        $arquivos = File::allFiles($diretorio);

        foreach ($arquivos as $arquivo) {
            $this->info("Executando {$arquivo->getRelativePathName()} ...");
            
            DB::unprepared($arquivo->getContents());
        }
    }
}
